
#################### Ozabaci, Henderson, and Su's (2014) procedure ####################

########## 1st stage ##########

Dat.1=Dat[-c(1)]
iv=Dat.1[c(2)]

iv=as.matrix(iv)
n=nrow(Dat)
knots=floor(2*n^(1/5)+3)
iv.s=bs(iv,df=knots)

dat.11=Dat.1[-c(2)]
dat.1=cbind(iv.s,dat.11)

ols=lm(wheat_aid~.,data=dat.1)
res=residuals(ols)
res=as.matrix(res)

########## 2nd stage ##########

Dat.2=Dat[-c(3)]
en=Dat.2[c(2)]

en=as.matrix(en)
en.s=bs(en,df=knots)

dat.22=Dat.2[-c(2)]
dat.2=cbind(res,en.s,dat.22)
ols=lm(intra_state~.,data=dat.2)
fit=fitted.values(ols)
fit=as.matrix(fit)

nn=ncol(en.s)
coef=coefficients(ols)[3:(3+nn-1)]
coef[is.na(coef)]=0
coef=as.matrix(coef)

x=dat.2[c(2:(2+nn-1))]
x=as.matrix(x)

fit.x=x%*%coef

y=dat.2$intra_state
y=as.matrix(y)

y.s=y-fit+fit.x

########## 3th stage ##########

y.s=as.numeric(y.s)
en=as.numeric(en)

bwll=npregbw(y.s~en,regtype="ll",residuals=TRUE,gradients=TRUE,bwmethod="cv.ls")
#bwll=npregbw(y.s~en,regtype="ll",residuals=TRUE,gradients=TRUE,bwmethod="cv.aic")#
# only for two cases: 5 year window and low ethnic polarization #
llls=npreg(bws=bwll,regtype="ll",residuals=TRUE,gradients=TRUE)
grad=gradients(llls)[,1]
grad=as.matrix(grad)

# split the full sample to two types of countries #

z=cbind(grad,I)
z.1=subset(z,I==1)
z.2=subset(z,I==0)
g1=z.1[,1]
g2=z.2[,1]

########## descriptive statistics ##########

summary(g1)
summary(g2)
